<?php
header('Content-Type: application/json');

// Database connection
$servername = "localhost";
$username_db = "templesm_longsmm";
$password_db = "templesm_longsmm";
$dbname = "templesm_longsmm";

// Get the transaction ID from the URL parameters or request
$tran_id = isset($_GET['tran_id']) ? $_GET['tran_id'] : null;

if ($tran_id) {
    // Create connection
    $conn = new mysqli($servername, $username_db, $password_db, $dbname);

    // Check connection
    if ($conn->connect_error) {
        echo json_encode(["status" => "ERROR", "message" => "Connection failed: " . $conn->connect_error]);
        exit();
    }

    // Prepare the SQL statement to select the md5 and other details for the given tran_id
    $stmt = $conn->prepare("SELECT md5, username, amount, payment_status FROM payment_qrcode WHERE tran_id = ?");
    $stmt->bind_param("s", $tran_id);

    // Execute the query
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Fetch the md5, username, and amount from the result
        $row = $result->fetch_assoc();
        $md5 = $row['md5'];
        $username = $row['username'];
        $amount = $row['amount'];
        $payment_status = $row['payment_status'];

        // Check if the payment status is already SUCCESS
        if ($payment_status === 'SUCCESS') {
            echo json_encode(["status" => "ERROR", "message" => "Payment has already been processed successfully"]);
            exit();
        }

        // API request logic
        $accessToken = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJkYXRhIjp7ImlkIjoiMDYwYjNkYTFjYTJiNDNhNiJ9LCJpYXQiOjE3NDc3NDgzMzcsImV4cCI6MTc1NTUyNDMzN30.nv8PasXDB64Mos3WPu3L62Tfo2_LurtjAcvN4AuFlsY";
        $apiUrl = "https://api-bakong.nbc.gov.kh/v1/check_transaction_by_md5";

        // Initialize cURL
        $curl = curl_init();
        curl_setopt_array($curl, [
            CURLOPT_URL => $apiUrl,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => json_encode(["md5" => $md5]),
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer $accessToken",
                "Content-Type: application/json"
            ],
        ]);

        // Execute the request and get the response
        $response = curl_exec($curl);

        // Check for errors in cURL
        if (curl_errno($curl)) {
            echo json_encode(["status" => "ERROR", "message" => curl_error($curl)]);
            curl_close($curl);
            exit();
        }

        // Decode the API response
        $responseData = json_decode($response, true);

        // Check if the API responseCode is 0 (successful transaction)
        if (isset($responseData['responseCode']) && $responseData['responseCode'] === 0) {
            // Prepare the SQL statement to update the payment_status to SUCCESS
            $updateStmt = $conn->prepare("UPDATE payment_qrcode SET payment_status = 'SUCCESS' WHERE tran_id = ?");
            $updateStmt->bind_param("s", $tran_id);

            // Execute the update statement
            if ($updateStmt->execute()) {
                // Send notification to Telegram
                if (!sendTelegramNotification($username, $amount, $tran_id)) {
                    echo json_encode(["status" => "WARNING", "message" => "Notification sent, but there was an issue with Telegram"]);
                } else {
                    echo json_encode(["status" => "SUCCESS"]);
                }
            } else {
                echo json_encode(["status" => "ERROR", "message" => "Failed to update payment status"]);
            }

            // Close the update statement
            $updateStmt->close();
        } else {
            echo json_encode(["status" => "ERROR", "message" => "Transaction check failed", "responseMessage" => $responseData['responseMessage']]);
        }

        // Close cURL session
        curl_close($curl);
    } else {
        echo json_encode(["status" => "ERROR", "message" => "No data found for the provided transaction ID"]);
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["status" => "ERROR", "message" => "Transaction ID not provided"]);
}

// Function to send notification to Telegram
function sendTelegramNotification($username, $amount, $tran_id) {
    $botToken = "7915153806:AAFvwrVnSNwu7cR9L_rQdmxX4jiBgLjK7h4";
    $chatId = "-1002665620733";

    // Prepare the message
    $message = "ការអាប់ដេតស្ថានភាពបង់ប្រាក់:\n" .
               "- ឈ្មោះអ្នកប្រើប្រាស់: $username\n" .
               "- ចំនួនទឹកប្រាក់: $amount$\n" .
               "- លេខសម្គាល់ប្រតិបត្តិការ: $tran_id\n" .
               "- ស្ថានភាព៖ ជោគជ័យ";

    // Initialize cURL for Telegram
    $url = "https://api.telegram.org/bot$botToken/sendMessage";
    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    ];

    // Initialize cURL
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_URL, $url);
    curl_setopt($curl, CURLOPT_POST, true);
    curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER , true);

    // Execute the request
    $response = curl_exec($curl);

    // Check for errors
    if ($response === false) {
        error_log('Telegram API error: ' . curl_error($curl));
        curl_close($curl);
        return false; // Indicate failure
    }

    // Close cURL session
    curl_close($curl);
    return true; // Indicate success
}