<?php
// Database connection
$servername = "localhost"; // Your DB server name
$username_db = "templesm_longsmm";      // Your DB username
$password_db = "templesm_longsmm";          // Your DB password
$dbname = "templesm_longsmm";  // Your database name

// Create connection
$conn = new mysqli($servername, $username_db, $password_db, $dbname);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Check if tran_id is passed in the URL
$tran_id = isset($_GET['tran_id']) ? $_GET['tran_id'] : null;

$paymentData = null; // Initialize variable to hold payment data

if ($tran_id) {
    // Prepare the SQL statement
    $stmt = $conn->prepare("SELECT amount, md5, qr, tran_id FROM payment_qrcode WHERE tran_id = ?");
    $stmt->bind_param("s", $tran_id); // Bind the tran_id to the query

    // Execute the query
    $stmt->execute();

    // Get the result
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        // Fetch the data
        $paymentData = $result->fetch_assoc();
    } else {
        echo "No data found for the provided transaction ID.";
    }

    // Close the statement and connection
    $stmt->close();
} else {
    echo "Transaction ID not provided.";
}

$conn->close();
?>
<!DOCTYPE html>
<html lang="en">

<head>
  <title>KHQR - CamboPay</title>
  <meta property="og:title" content="KHQR" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <meta charset="utf-8" />
  <meta property="twitter:card" content="summary_large_image" />

  <style data-tag="reset-style-sheet">
    html {
      line-height: 1.15;
    }

    body {
      margin: 0;
    }

    * {
      box-sizing: border-box;
      border-width: 0;
      border-style: solid;
    }

    p,
    li,
    ul,
    pre,
    div,
    h1,
    h2,
    h3,
    h4,
    h5,
    h6,
    figure,
    blockquote,
    figcaption {
      margin: 0;
      padding: 0;
    }

    button {
      background-color: transparent;
    }

    button,
    input,
    optgroup,
    select,
    textarea {
      font-family: inherit;
      font-size: 100%;
      line-height: 1.15;
      margin: 0;
    }

    button,
    select {
      text-transform: none;
    }

    button,
    [type="button"],
    [type="reset"],
    [type="submit"] {
      -webkit-appearance: button;
    }

    button::-moz-focus-inner,
    [type="button"]::-moz-focus-inner,
    [type="reset"]::-moz-focus-inner,
    [type="submit"]::-moz-focus-inner {
      border-style: none;
      padding: 0;
    }

    button:-moz-focus,
    [type="button"]:-moz-focus,
    [type="reset"]:-moz-focus,
    [type="submit"]:-moz-focus {
      outline: 1px dotted ButtonText;
    }

    a {
      color: inherit;
      text-decoration: inherit;
    }

    input {
      padding: 2px 4px;
    }

    img {
      display: block;
    }

    html {
      scroll-behavior: smooth
    }
  </style>
  <style data-tag="default-style-sheet">
    html {
      font-family: Inter;
      font-size: 16px;
    }

    body {
      font-weight: 400;
      font-style: normal;
      text-decoration: none;
      text-transform: none;
      letter-spacing: normal;
      line-height: 1.15;
      color: var(--dl-color-gray-black);
      background-color: var(--dl-color-gray-white);


    }

    .qrcode-loadingpic {
      /* Set initial rotation */
      transform: rotate(0deg);

      /* Define the animation */
      animation: rotateAnimation 1s linear infinite;
    }

    /* Define the keyframes for the rotation animation */
    @keyframes rotateAnimation {
      from {
        transform: rotate(0deg);
      }

      to {
        transform: rotate(360deg);
      }
    }
  </style>
  <link rel="shortcut icon" href="img/unnamed.png" type="icon/png" sizes="32x32" />
  <link rel="stylesheet"
    href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&amp;display=swap"
    data-tag="font" />
  <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Dangrek:wght@400&amp;display=swap"
    data-tag="font" />
  <link rel="stylesheet"
    href="https://fonts.googleapis.com/css2?family=Fira+Sans:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&amp;display=swap"
    data-tag="font" />
  <link rel="stylesheet" href="https://unpkg.com/@teleporthq/teleport-custom-scripts/dist/style.css" />
</head>

<body>
  <link rel="stylesheet" href="css/style.css" />
  <div>
    <link href="css/qrcode.css" rel="stylesheet" />

    <div class="qrcode-container">
      <div class="qrcode-body body">
        <img src="https://link.payway.com.kh/images/loading.svg" alt="image" class="qrcode-loadingpic" />
        <span class="qrcode-minutes">
          <span id="countdown">3:00</span>
          <br />
          <br />
        </span>
        <span id="name" class="qrcode-name"><b style="font-size:13px;">LONG-SMM.COM</b></span>
        <span id="currency" class="qrcode-currency">$</span>
        <span id="amount" class="qrcode-amount">
            <?php echo $paymentData['amount']; ?>
        </span>
        <div class="qrcode-head">
          <div class="qrcode-header">
            <div class="qrcode-container1">
              <div class="qrcode-container2"></div>
              <div class="qrcode-container3">
                <div class="qrcode-container4 qrhrader"></div>
                <img alt="image" src="public/khqr%20logo-200h.png" class="qrcode-image logo" />
              </div>
            </div>
          </div>
        </div>
        <div class="qrcode-line line">
          <div class="qrcode-qrcode qrcode">
           <img id="qr-image" alt="image" src="<?php echo $paymentData['qr']; ?>" class="qrcode-qr" />
            <img id="logo" alt="image" src="https://checkout.payway.com.kh/images/usd-khqr-logo.svg"
              class="qrcode-logo" /> 
          </div>
        </div>
        <img alt="image"
          src="public/payment_icons-cd5e952dde3b886dea1fd1b983d43ce372f1692dec253808ec654096d2feb701-200h.png"
          class="qrcode-banklogo" />
      </div>
    </div>
  </div>
</body>
    <script>
  // Function to check the transaction status
  function checkTransactionStatus() {
    const tran_id = "<?php echo $paymentData['tran_id']; ?>"; // Insert the transaction ID dynamically
    const apiUrl = `https://longg-smm.com/payment/api/transaction.php?tran_id=${tran_id}`;

    // Make an AJAX request to the API to check transaction status
    fetch(apiUrl)
      .then(response => response.json()) // Parse the response as JSON
      .then(data => {
        // Check if the status is SUCCESS
        if (data.status === "SUCCESS") {
          // Make another request to update balance
          updateBalance();
        }
      })
      .catch(error => {
        console.error("Error checking transaction status:", error);
      });
  }

  // Function to update balance when transaction is successful
  function updateBalance() {
    const updateBalanceUrl = "https://longg-smm.com/payment/api/update.php";

    // Make a request to the balance update API
    fetch(updateBalanceUrl, {
      method: 'GET', // Assuming a GET request is required, change to POST if needed
    })
      .then(response => {
        if (response.status === 200) {
          // Redirect to the add funds page if the balance update is successful
          window.location.href = "https://longg-smm.com/addfunds";
        } else {
          console.error("Failed to update balance. Response code:", response.status);
        }
      })
      .catch(error => {
        console.error("Error updating balance:", error);
      });
  }

  // Set an interval to check the transaction status every second
  setInterval(checkTransactionStatus, 1000); // 1000ms = 1 second
  
   document.addEventListener("DOMContentLoaded", function () {
    // Set the countdown duration in seconds
    let countdownDuration = 180; // 3 minutes * 60 seconds

    // Get the countdown element
    const countdownElement = document.getElementById("countdown");

    // Update the countdown every second
    const countdownInterval = setInterval(function () {
      const minutes = Math.floor(countdownDuration / 60);
      const seconds = countdownDuration % 60;

      // Display the countdown in the format MM:SS
      countdownElement.textContent = `${minutes}:${seconds < 10 ? '0' : ''}${seconds}`;

      // Decrease the countdown duration
      countdownDuration--;

      // Check if the countdown has reached 0
      if (countdownDuration < 0) {
        // Redirect to index.php when the countdown reaches 0
        window.location.href = 'https://longg-smm.com/addfunds';

        // Clear the interval to stop the countdown
        clearInterval(countdownInterval);
      }
    }, 10000); // Update every 10000 milliseconds (10 second)
  });
</script>

</html>