// Search function and dropdown
  $(document).ready(function () {
    // When the search input changes
    $('#search_services_field').on('input', function () {
      const inputValue = $(this).val().trim();

      // If the input is empty, clear and hide the dropdown
      if (!inputValue) {
        $('#dropdown_for_search').html('').hide();
      } else {
        // AJAX call
        $.ajax({
          type: 'POST',
          url: '/ajax_data',
          data: {
            action: 'service_search',
            search_term: inputValue
          },
          beforeSend: function () {
            $('#dropdown_for_search').html(`
              <div class="dropdown-item" style="padding: 6px 12px; cursor: pointer;">
                <span class="badge service_id_badge bg-primary">Searching</span> Please Wait...
              </div>`).show();
          },
          success: function (response) {
            if (response.trim()) {
              $('#dropdown_for_search').html(response).show();
            } else {
              $('#dropdown_for_search').html('').hide(); // Hide if response is empty
            }
          },
          error: function (error) {
            console.error('AJAX error:', error);
            $('#dropdown_for_search').html('').hide(); // Hide if AJAX error occurs
          }
        });
      }
    });

    // Search clear function
    $('#clear_search').on('click', function () {
      $('#search_services_field').val(''); // Clear search box
      $('#dropdown_for_search').html('').hide(); // Clear and hide dropdown
    });
  });

  // Service click handler
  function serviceclicked(sid, cid) {
    console.log("Service ID:", sid, "Category ID:", cid);

    // Select category
    $(`#neworder_category option[value=${cid}]`).prop('selected', true).change();

    // After a 1-second delay, select service
    setTimeout(() => {
      $(`#neworder_services option[value=${sid}]`).prop('selected', true).change();

      // Update search field with service name
      let serviceName = $(`#neworder_services option[value=${sid}]`).text().trim();
      $('#search_services_field').val(serviceName); // Display name in search box
      $('#dropdown_for_search').html('').hide(); // Clear and hide dropdown
    }, 1000);
  }  